﻿#pragma warning disable 1591
//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:4.0.30319.269
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Microsoft.Web.Helpers
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Net;
    using System.Web;
    using System.Web.Helpers;
    using System.Web.Security;
    using System.Web.UI;
    using System.Web.WebPages;
    using System.Web.WebPages.Html;
    using System.Globalization;
    using System.Text;
    using System.Web.WebPages.Scope;
    using Microsoft.Internal.Web.Utils;
    using Resources;
    
    [System.CodeDom.Compiler.GeneratedCodeAttribute("RazorSingleFileGenerator", "0.6.0.0")]
    public class LinkShare : System.Web.WebPages.HelperPage
    {
#line hidden

    internal static readonly object _bitlyApiKey = new object();
    internal static readonly object _bitlyLogin = new object();
    private static readonly Lazy<IEnumerable<LinkShareSite>> _allSites = new Lazy<IEnumerable<LinkShareSite>>(() =>
        from site in (LinkShareSite[])Enum.GetValues(typeof(LinkShareSite))
#pragma warning disable 0618
        where site != LinkShareSite.All && site != LinkShareSite.GoogleBuzz
#pragma warning restore 0618
        select site
    );

    public static string BitlyApiKey {
        get {
            return ScopeStorage.CurrentScope[_bitlyApiKey] as string;
        }

        set {
            if (value == null) {
                throw new ArgumentNullException("value");
            }
            ScopeStorage.CurrentScope[_bitlyApiKey] = value;
        }
    }

    public static string BitlyLogin {
        get {
            return ScopeStorage.CurrentScope[_bitlyLogin] as string;
        }

        set {
            if (value == null) {
                throw new ArgumentNullException("value");
            }
            ScopeStorage.CurrentScope[_bitlyLogin] = value;
        }
    }

    private static string GetShortenedUrl(string pageLinkBack) {
        if (BitlyLogin.IsEmpty() || BitlyApiKey.IsEmpty()) {
            return pageLinkBack;
        }
        string encodedPageLinkBack = HttpUtility.UrlEncode(pageLinkBack);
        string key = "Bitly_pageLinkBack_" + BitlyApiKey + "_" + encodedPageLinkBack;
        string shortUrl = WebCache.Get(key) as string;
        if (shortUrl != null) {
            return shortUrl;
        }

        string bitlyReq = "http://api.bit.ly/v3/shorten?format=txt&longUrl=" + encodedPageLinkBack + "&login=" + BitlyLogin + "&apiKey=" + BitlyApiKey;
        try {
            shortUrl = GetWebResponse(bitlyReq);
        }
        catch (WebException) {
            return pageLinkBack;
        }
        if (shortUrl != null) {
            WebCache.Set(key, shortUrl);
            return shortUrl;
        }
        return pageLinkBack;
    }

    private static string GetWebResponse(string address) {
        WebRequest request = WebRequest.Create(address);
        request.Method = "GET";
        request.Timeout = 5 * 1000; //5 seconds
        using (var response = (HttpWebResponse)request.GetResponse()) {
            if (response.StatusCode != HttpStatusCode.OK) {
                return null;
            }
            using (Stream stream = response.GetResponseStream()) {
                using (MemoryStream memStream = new MemoryStream()) {
                    stream.CopyTo(memStream);
                    // Review: Should we use the ContentEncoding from response?
                    return Encoding.UTF8.GetString(memStream.ToArray());
                }
            }
        }
    }

    /// <summary>
    /// Returns an ordered list of LinkShareSite based on position of "All" parameter occurs in the list.
    /// </summary>
    /// <remarks>
    /// The LinkShareSite is accepted as a params array.
    /// In the event that no value is provided or the LinkShareSite.All is the first param, we display all the sites in the order they appear in the enum.
    /// If not, the items we look for the first occurence of LinkShareSite.All in the array. 
    /// The items that appear before this appear in the order they are specified. The All is replaced by all items in the enum that were not already specified by the user 
    /// in the order they appear in the enum.
    /// e.g.  sites = [] { Twitter, Facebook, Digg, All }
    /// Would result in returning {Twitter, Facebook, Digg, Delicious, GoogleBuzz, Reddit, StumbleUpon} 
    /// </remarks>
    internal static IEnumerable<LinkShareSite> GetSitesInOrder(LinkShareSite[] linkSites) {
        var allSites = _allSites.Value;
        if (linkSites == null || !linkSites.Any() || linkSites.First() == LinkShareSite.All) {
            // Show all sites
            return allSites;
        }
        var result = linkSites.TakeWhile(c => c != LinkShareSite.All).ToList();
        if (result.Count != linkSites.Length) {
            return Enumerable.Concat(result, allSites.Except(result));
        }
        else {
            return result;
        }
    }

    private static void ConstructPageLinkBack(ref string pageLinkBack, out string shortenedUrl) {
        HttpContext context = HttpContext.Current;
        if ((pageLinkBack == null) && (context != null)) {
            pageLinkBack = context.Request.Url.GetComponents(UriComponents.SchemeAndServer | UriComponents.Path, UriFormat.Unescaped);
        }
        shortenedUrl = GetShortenedUrl(pageLinkBack);
    }
#line hidden
public static System.Web.WebPages.HelperResult GetHtml(string pageTitle,
    string pageLinkBack = null,
    string twitterUserName = null,
    string additionalTweetText = null,
    params LinkShareSite[] linkSites) {
return new System.Web.WebPages.HelperResult(__razor_helper_writer => {


                                       

    if (pageTitle.IsEmpty()) {
        throw new ArgumentException(String.Format(CultureInfo.CurrentUICulture, CommonResources.Argument_Cannot_Be_Null_Or_Empty, "pageTitle"), "pageTitle");
    }

    string shortenedUrl;
    ConstructPageLinkBack(ref pageLinkBack, out shortenedUrl);

    pageLinkBack = HttpUtility.UrlEncode(pageLinkBack);
    shortenedUrl = HttpUtility.UrlEncode(shortenedUrl);
    pageTitle = HttpUtility.UrlEncode(pageTitle);

    foreach (var site in GetSitesInOrder(linkSites)) {
        switch (site) {
            case LinkShareSite.Delicious:

WriteLiteralTo(@__razor_helper_writer, "                <a href=\"http://delicious.com/save?v=5&amp;noui&amp;jump=close&am" +
"p;url=");


                                                         WriteTo(@__razor_helper_writer, shortenedUrl);

WriteLiteralTo(@__razor_helper_writer, "&amp;title=");


                                                                                   WriteTo(@__razor_helper_writer, pageTitle);

WriteLiteralTo(@__razor_helper_writer, "\" target=\"_blank\" title=\"Add to del.icio.us\">\r\n                    <img alt=\"Add " +
"to del.icio.us\" src=\"http://www.delicious.com/static/img/delicious.small.gif\" st" +
"yle=\"border:0; height:16px; width:16px; margin:0 1px;\" title=\"Add to del.icio.us" +
"\" /></a>\r\n");


                break;

            case LinkShareSite.Digg:

WriteLiteralTo(@__razor_helper_writer, "                <a href=\"http://digg.com/submit?url=");


                      WriteTo(@__razor_helper_writer, pageLinkBack);

WriteLiteralTo(@__razor_helper_writer, "&amp;title=");


                                                WriteTo(@__razor_helper_writer, pageTitle);

WriteLiteralTo(@__razor_helper_writer, "\" target=\"_blank\" title=\"Digg!\">\r\n                    <img alt=\"Digg!\" src=\"http:" +
"//digg.com/img/badges/16x16-digg-guy.gif\" style=\"border:0; height:16px; width:16" +
"px; margin:0 1px;\" title=\"Digg!\" /></a>\r\n");


                break;
            case LinkShareSite.Facebook:

WriteLiteralTo(@__razor_helper_writer, "                <a href=\"http://www.facebook.com/sharer.php?u=");


                                WriteTo(@__razor_helper_writer, shortenedUrl);

WriteLiteralTo(@__razor_helper_writer, "&amp;t=");


                                                      WriteTo(@__razor_helper_writer, pageTitle);

WriteLiteralTo(@__razor_helper_writer, "\" target=\"_blank\" title=\"Share on Facebook\">\r\n                    <img alt=\"Share" +
" on Facebook\" src=\"http://www.facebook.com/favicon.ico\" style=\"border:0; height:" +
"16px; width:16px; margin:0 1px;\" title=\"Share on Facebook\" /></a>\r\n");


                break;
            case LinkShareSite.Reddit:

WriteLiteralTo(@__razor_helper_writer, "                <a href=\"http://reddit.com/submit?url=");


                        WriteTo(@__razor_helper_writer, pageLinkBack);

WriteLiteralTo(@__razor_helper_writer, "&amp;title=");


                                                  WriteTo(@__razor_helper_writer, pageTitle);

WriteLiteralTo(@__razor_helper_writer, "\" target=\"_blank\" title=\"Reddit!\">\r\n                    <img alt=\"Reddit!\" src=\"h" +
"ttp://www.Reddit.com/favicon.ico\" style=\"border:0; height:16px; width:16px; marg" +
"in:0 1px;\" title=\"Reddit!\" /></a>\r\n");


                break;
            case LinkShareSite.StumbleUpon:

WriteLiteralTo(@__razor_helper_writer, "                <a href=\"http://www.stumbleupon.com/submit?url=");


                                 WriteTo(@__razor_helper_writer, pageLinkBack);

WriteLiteralTo(@__razor_helper_writer, "&amp;title=");


                                                           WriteTo(@__razor_helper_writer, pageTitle);

WriteLiteralTo(@__razor_helper_writer, "\" target=\"_blank\" title=\"Stumble it!\">\r\n                    <img alt=\"Stumble it!" +
"\" src=\"http://cdn.stumble-upon.com/images/16x16_su_round.gif\" style=\"border:0; h" +
"eight:16px; width:16px; margin:0 1px;\" title=\"Stumble it!\" /></a>\r\n");


                break;
#pragma warning disable 0618
            // Obviously we need to use the obsoleted GoogleBuzz enum value to check for it :).
            case LinkShareSite.GoogleBuzz:
                throw new NotSupportedException(HelpersToolkitResources.GoogleBuzz_NotSupported);
#pragma warning restore 0618
            case LinkShareSite.Twitter:
                string status = String.Empty;
                if (!twitterUserName.IsEmpty()) {
                    status += ", (via @@" + twitterUserName + ")";
                }
                if (!additionalTweetText.IsEmpty()) {
                    status += ' ' + additionalTweetText;
                }
                status = HttpUtility.UrlEncode(status);

WriteLiteralTo(@__razor_helper_writer, "                <a href=\"http://twitter.com/home/?status=");


                           WriteTo(@__razor_helper_writer, pageTitle);

WriteLiteralTo(@__razor_helper_writer, "%3a+");


                                           WriteTo(@__razor_helper_writer, shortenedUrl);


                                                          WriteTo(@__razor_helper_writer, status);

WriteLiteralTo(@__razor_helper_writer, "\" target=\"_blank\" title=\"Share on Twitter\">\r\n                    <img alt=\"Share " +
"on Twitter\" src=\"http://twitter.com/favicon.ico\" style=\"border:0; height:16px; w" +
"idth:16px; margin:0 1px;\" title=\"Share on Twitter\" />\r\n                </a>\r\n");


                break;
        }
    }

});

}


        public LinkShare()
        {
        }
        protected static System.Web.HttpApplication ApplicationInstance
        {
            get
            {
                return ((System.Web.HttpApplication)(Context.ApplicationInstance));
            }
        }
    }
}
#pragma warning restore 1591
